#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/cdsSRf
//   -----= Inigo Quilez =-----
vec3 hsv2rgb_smooth( in vec3 c )
{
    vec3 rgb = clamp( abs(mod(c.x*6.0+vec3(0.0,4.0,2.0),6.0)-3.0)-1.0, 0.0, 1.0 );
	rgb = rgb*rgb*(3.0-2.0*rgb);
    
	return c.z * mix( vec3(1.0), rgb, c.y);
}

float hash(float n) { return fract(sin(n)*43758.5453123); }

float noise(in vec2 x)
{
    vec2 p = floor(x);
    vec2 f = fract(x);

    f = f*f*(3.0-2.0*f);

    float n = p.x + p.y*57.0;
    float res = mix(mix(hash(n+  0.0), hash(n+  1.0), f.x),
                    mix(hash(n+ 57.0), hash(n+ 58.0), f.x), f.y);
    return res;
}
//   -------= IQ END =-------

mat2 Rot(in float a) //2D
{
    float s = sin(a);
    float c = cos(a);
    return mat2(c, -s, s, c);
}

#define Rot2D(p, a) p=cos(a)*p+sin(a)*vec2(p.y,-p.x)
vec3 Rot(in vec3 p, in vec3 r) //las
{
    Rot2D(p.xz, r.y);
    Rot2D(p.yx, r.z);
    Rot2D(p.zy, r.x);
    return p;
}


vec2 sdKMC( in vec3 p,    //KIFS Mengerbox
            in int iters,
            in vec3 fTra,
            in vec3 fRot,
            in vec4 para)
{
    int i;
    float d, col = 0.;
    float x1, y1;
    float r = p.x*p.x + p.y*p.y + p.z*p.z;
    
    for(i = 0; i < iters && r < 10e2; i++)
    {
        p = abs(p);

        if (p.x-p.y < 0.) { x1=p.y; p.y=p.x; p.x=x1;}
        if (p.x-p.z < 0.) { x1=p.z; p.z=p.x; p.x=x1;}
        if (p.y-p.z < 0.) { y1=p.z; p.z=p.y; p.y=y1;}

        p.z -= 0.5 * para.x * (para.y - 1.) / para.y;
        p.z = -abs(p.z);
        p.z += 0.5 * para.x * (para.y - 1.) / para.y;

        p.x = para.y * p.x - para.z * (para.y - 1.);
        p.y = para.y * p.y - para.w * (para.y - 1.);
        p.z = para.y * p.z;

        col = r;
        r = p.x*p.x + p.y*p.y + p.z*p.z;
        
        p -= fTra;
        p = Rot(p, fRot);
    }
    
    d = length(p) * pow(para.y, float(-i));

    return vec2(d, col);
}

vec3 R(in vec2 uv, in vec3 p, in vec3 l, in float z)
{
    vec3 f = normalize(l-p),
        r = normalize(cross(vec3(0,1,0), f)),
        u = cross(f,r),
        c = p+f*z,
        i = c + uv.x*r + uv.y*u,
        d = normalize(i-p);
    return d;
}

//                    = The Way of Light =         
//               by Maximilian Knape  ·∑>| 2022            
// -----------------------------------------------------------
// This work is licensed under a Creative Commons Attribution-
//        NonCommercial-ShareAlike 3.0 Unported License

#define GAMMA vec3(1) //vec3(.4545)

#define MAX_STEPS 300
#define MAX_DIST 500.
#define MIN_DIST 10.
#define STEP_FAC 5.

#define SURF_DIST .001
#define SURF_MUL 1000.
#define SURF_EXP 5.

#define PP_ACES 0.
#define PP_CONT 0.8
#define PP_VIGN 2.0

#define PI 3.14159265358979
#define TAU 6.28318530717958
#define S(x,y,t) smoothstep(x,y,t)

vec2 Map(vec3 p) 
{    
    float d = MAX_DIST, col = 0.;
    vec3 op = p;
    
    float s = 22.; //size
    float sp = iTime*5.; //speed
    
    
    p.z = mod(abs(s*2. - mod(p.z + sp, s*4.)), s*4.); //mirror
    p.xy += normalize(p.xy) * (S(0., MAX_DIST, op.z)*40. - S(0., MAX_DIST, -op.z)*30.); //xy size
    p.xy *= Rot(PI/4. * step(0., sin(PI*(op.z + sp) / (8.*s)))); //rotator
    
    float cy = length(op.xy);
    if (cy < s*5.) //bounding cylinder
    {
        vec2 glow = sdKMC( //light fractal
                p/8., 3, vec3(pow(sin(iTime/32. + op.z/s*.1), 3.)*2.), 
                vec3(pow(sin(iTime/42. + op.z/s*.01), 3.)*PI/4.), 
                vec4(1,3,5,5)); 

        float split = 30. + sin(iTime/13.)*10.; //two colors/materials
        
        glow.x = pow(glow.x, 1.5 + step(split, glow.y) * (sin(iTime - op.z/s)-1.)*.3); //color waves
        glow.x -= (pow(sin(-(op.z + sp) / s), 2.) - step(split, glow.y))*.001; //thickness
        
        col = mix(col, 1.0 - step(glow.y, split), step(glow.x, d)); //color
        d = min(glow.x, d); 
    }
    else d = min(d, cy - s*7.);
    
    return vec2(d, col);
}

vec3 Palette(int index, float depth)
{
    switch (index)
    {
        case 0: return vec3(1., 1., 1.)*.8;
        case 1: return hsv2rgb_smooth(vec3(fract(depth), .9, 1.));
    }
    return vec3(0.);
}

vec3 RTM(vec3 ro, vec3 rd) 
{
    int steps;
    float sum = 0.;
	float s = 1.;
    float d = MIN_DIST;
    const float a = 1. / float(MAX_STEPS); 
    vec3 p = vec3(0), col = vec3(1);
    
    for(int i = 0; i < MAX_STEPS; i++) 
    {    
        float sd = (SURF_DIST * (pow(d/MAX_DIST, SURF_EXP)*SURF_MUL+1.)); //can be DOF
        if (s < sd || d > MAX_DIST) break;
        
        steps = i;
        p = ro + rd*d;
        
        vec2 map = Map(p);
        col = mix(col, Palette(int(floor(map.y)), (p.z-iTime*5.)/MAX_DIST*.5), .02 * (1.-sum)); //color overlap
        
        s = max(abs(map.x), 2. * sd);
        d += s * STEP_FAC * (1.1 - fract(map.y));
        
        sum += a;
    }
    
    float dp = pow(1. - (length(ro - p) / MAX_DIST), SURF_EXP);
    
    col *= sum - dp;
    
    if (dp <= 10e-1) //Background
    {
        float dir = dot(vec3(0,0,1), rd)*.5+.5;
        float bg = pow(dir, 5.)*.2; //glow
        bg += pow(dir, 5000.)*.8; //core
        bg *= (1. - S(.99, .9, dir) * //rays
                    noise(normalize(vec2(abs(rd.x), rd.y)*Rot(iTime/25.)) * 
                    (10.+5.*sin(iTime/17.))));
        
        col += bg;
    }
    
    col *= pow(1. - max(0., dot(vec3(0,0,-1.), rd)), .1);
        
    return col;
}

vec4 PP(vec3 col, vec2 uv) //PostProcessing
{
    col = mix(col, (col * (2.51 * col + 0.03)) / (col * (2.43 * col + 0.59) + 0.14), PP_ACES);
    col = mix(col, S(vec3(0.1), vec3(1.), col), PP_CONT);    
    col *= S(PP_VIGN,-PP_VIGN/5., dot(uv,uv)); 
    col = pow(col, GAMMA);
    
    return vec4(col, 1.);
}

void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    vec2 uv = (fragCoord-.5 * iResolution.xy) / iResolution.y;
	vec2 m = iMouse.xy / iResolution.xy;
    if (length(m) <= 0.) m = vec2(.5);

    vec3 ro = vec3(0., 0., -10.);
    ro.yz *= Rot(-m.y * PI + PI*.5);
    ro.xz *= Rot(-m.x * PI*2. - PI);
    vec3 rd = R(uv, ro, vec3(0., 0., 0.), .7);

    fragColor = PP(RTM(ro, rd), uv);
}


///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


